# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 9
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR9_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR9(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early Rounds (1-3): Cooperate unconditionally
    if current_round <= 3:
        return "C"
    
    # Mid Rounds (4-7)
    if 4 <= current_round <= 7:
        if "D" not in opp_history:
            return "C"
        else:
            # Tit-for-tat with forgiveness: defect if opponent defected last round, but cooperate every 3rd defection
            if opp_history[-1] == "D":
                defections_in_mid = opp_history[3:current_round-1].count("D")
                if defections_in_mid % 3 == 2:
                    return "C"
                else:
                    return "D"
            else:
                return "C"
    
    # Final Rounds (8-10)
    if current_round >= 8:
        total_defections = opp_history.count("D")
        if total_defections <= 1:
            return "C"
        else:
            # Check if defections were clustered early and they've cooperated since
            early_defections = opp_history[:3].count("D")
            recent_cooperation = "D" not in opp_history[3:]
            if early_defections > 0 and recent_cooperation:
                return "C"
            else:
                return "D"
    
    # Default fallback (shouldn't reach here)
    return "C"